/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn.transformation;

import java.util.List;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnSelectListValue;

/**
 * Transformation that aggregates the input set and produces an output set with
 * a single instance, which is the aggregated result
 */
@Beta
public interface CqnAggregateTransformation extends CqnTransformation {

	/**
	 * Returns expressions that specify how to aggregate the input set
	 * 
	 * @return expressions that specify how to aggregate the input set
	 */
	List<CqnSelectListValue> aggregateExpressions();

	@Override
	default Kind kind() {
		return Kind.AGGREGATE;
	}
}
