/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.hana;

import java.util.List;
import java.util.Optional;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSortSpecification;

/**
 * A table function that generates a hierarchy based on recursive parent-child source data
 */
@Beta
public interface CqnHierarchyGenerator extends CqnHierarchy {
	
	/**
	 * A filter condition that identifies the root nodes of the hierarchy generated by this generator
	 * 
	 * @return a reference to the filter condition that identifies the root nodes
	 *         as a {@link CqnPredicate} wrapped in an {@link Optional}
	 */
	Optional<CqnPredicate> startWhere();
	
	List<CqnSortSpecification> orderBy();

	Integer depth();

	@Override
	default boolean isGenerator() {
		return true;
	}

	@Override
	default CqnHierarchyGenerator asGenerator() {
		return this;
	}

}
