/*******************************************************************
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.hana;

import java.util.Optional;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnPredicate;

@Beta
public interface CqnHierarchySubset extends CqnHierarchy {
	
	/**
	 * Specifies the start nodes as an additional input table or as a filter condition 
	 * A filter condition that specifies the start nodes of this hierarchy subset function
	 * 
	 * @return a reference to the filter condition that specifies the start nodes
	 *         as a {@link CqnPredicate} wrapped in an {@link Optional}
	 */
	Optional<CqnPredicate> startWhere();

	int from();

	int to();

	/*
	 * Returns true if the hierarchy is a navigation function like `ancestors` or
	 * `descendants`. Otherwise returns false.
	 */
	@Override
	default boolean isHierarchySubset() {
		return true;
	}

	@Override
	default CqnHierarchySubset asHierarchySubset() {
		return this;
	}

	default boolean isAncestors() {
		return false;
	}

	default boolean isDescendants() {
		return false;
	}

}
