/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

public interface CdsArrayedType extends CdsType {

	/**
	 * Returns the items' type of this {@code CdsArrayedType}.
	 * 
	 * @return the items' type of this arrayed type, not {@code null}
	 */
	CdsType getItemsType();

	@Override
	default boolean isArrayed() {
		return true;
	}

	@Override
	default void accept(CdsVisitor visitor) {
		visitor.visit(this);
	}

}
