/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

import java.math.BigDecimal;

public interface CdsDecimal extends CdsSimpleType {

	static final String PRECISION = "precision";
	static final String SCALE = "scale";

	/**
	 * Returns the precision of this {@code CdsDecimal}.
	 * 
	 * @return the precision of this Decimal type, not {@code null}
	 */
	default Integer getPrecision() {
		return get(PRECISION);
	}

	/**
	 * Returns the scale of this {@code CdsDecimal}.
	 * 
	 * @return the scale of this Decimal type, not {@code null}
	 */
	default Integer getScale() {
		return get(SCALE);
	}

	@Override
	default CdsBaseType getType() {
		return CdsBaseType.DECIMAL;
	}

	@Override
	default Class<?> getJavaType() {
		return BigDecimal.class;
	}

}
