/*********************************************************************
 * (C) 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.reflect.overlay;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;

/**
 * The {@code CdsAssociationExtender} allows to define and extend the underlying
 * {@link CdsElement} of type {@link CdsAssociationType}.
 */
@Beta
public interface CdsAssociationExtender {

	/**
	 * Sets a to-one cardinality for the association to the given target entity.
	 *
	 * @param qualifiedName the qualified name of the target entity
	 * @return this {@code CdsAssociationExtender}
	 */
	CdsAssociationExtender toOne(String qualifiedName);

	/**
	 * Sets a to-many cardinality for the association to the given target entity.
	 *
	 * @param qualifiedName the qualified name of the target entity
	 * @return this {@code CdsAssociationExtender}
	 */
	CdsAssociationExtender toMany(String qualifiedName);

	/**
	 * Sets the on-condition for the association.
	 *
	 * @param onCondition the on-condition
	 * @return this {@code CdsAssociationExtender}
	 */
	CdsAssociationExtender on(CqnPredicate onCondition);

	/**
	 * Adds an annotation to the element.
	 *
	 * @param key   the annotation key
	 * @param value the annotation value
	 * @return this {@code CdsAssociationExtender}
	 */
	CdsAssociationExtender addAnnotation(String key, Object value);

	/**
	 * Returns to the {@code CdsEntityExtender} that created this
	 * {@code CdsAssociationExtender}.
	 *
	 * @return the parent {@code CdsEntityExtender} to continue extending the entity
	 */
	CdsEntityExtender and();
}
