/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.transaction;

import java.io.Serial;
import java.sql.SQLException;

/**
 * Exception indicating that a transaction has been rolled back
 */
public class RollbackException extends TransactionException {

	@Serial
	private static final long serialVersionUID = 1L;

	public RollbackException(SQLException e) {
		super("transaction has been rolled back", e);
	}

	public RollbackException(String msg) {
		super(msg);
	}

}
