/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds;

import java.io.Serial;

/**
 * Thrown by the runtime when {@link Result#single()} is executed and the result is empty. This
 * exception will not cause the current transaction to be marked for rollback.
 */
public class EmptyResultException extends CdsException {

  @Serial private static final long serialVersionUID = 1L;

  public EmptyResultException(String message, Throwable cause) {
    super(message, cause);
  }

  public EmptyResultException(String message) {
    super(message);
  }
}
