/*
 * © 2018-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds;

import com.sap.cds.ql.StructuredType;

/**
 * Represents a single result data set of the {@link CdsDataStore}. It can be accessed as a {@code
 * Map} or, via the {@code as} method, in a typed way by an accessor interface. Moreover, it can be
 * serialized to JSON.
 */
public interface Row extends CdsData {

  /**
   * Returns this {@code Row} mapped to the given {@code type}.
   *
   * @param <T> the return type
   * @param type the type this {@code Row} is mapped to
   * @return this {@code Row} mapped to type {@code T}
   */
  <T> T as(Class<T> type);

  /**
   * Returns a reference to the entity this row originates from.
   *
   * @return the entity reference
   * @throws CdsException if this row does not reference an entity
   */
  StructuredType<?> ref();

  /**
   * Returns a reference from the entity this row originates from along the given path.
   *
   * @param path a path of association names separated by '.'
   * @return the entity reference
   * @throws CdsException if this row does not reference an entity
   */
  default StructuredType<?> to(String path) {
    return ref().to(path);
  }
}
