/*
 * © 2018-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.util.Locale;
import java.util.Optional;

public interface CqnJoin extends CqnSource, CqnToken {

  CqnSource left();

  CqnSource right();

  Optional<CqnPredicate> on();

  Type type();

  @Override
  default boolean isJoin() {
    return true;
  }

  @Override
  default CqnJoin asJoin() {
    return this;
  }

  enum Type {
    INNER,
    LEFT,
    RIGHT,
    FULL,
    CROSS;

    public static Type joinType(String type) {
      return Type.valueOf(type.toUpperCase(Locale.US));
    }

    @Override
    public String toString() {
      return name().toLowerCase(Locale.US);
    }
  }
}
