/*
 * © 2018-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

public final class CqnStar implements CqnSelectListItem {

  private static final CqnStar STAR = new CqnStar();

  private CqnStar() {}

  public static CqnStar star() {
    return STAR;
  }

  @Override
  public boolean isStar() {
    return true;
  }

  @Override
  public String toJson() {
    return "\"*\"";
  }

  @Override
  public String toString() {
    return toJson();
  }

  @Override
  public void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }
}
