/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.time.temporal.Temporal;

public interface CqnTemporalLiteral<E extends Temporal> extends CqnLiteral<E> {

  @Override
  default void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }

  @Override
  default boolean isTemporal() {
    return true;
  }
}
