/*
 * © 2018-2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import com.google.common.annotations.Beta;
import com.sap.cds.JSONizable;
import java.util.stream.Stream;

public interface CqnToken extends JSONizable {

  /**
   * Traverses the expression tree represented by this token with a given {@code visitor}. The
   * traversal order is <i>depth-first</i>. If this token has child nodes they are traversed first
   * by dispatching the visitor to the children's {@code accept} methods.
   *
   * <p>Afterwards this token is passed to the visitor's {@code visit} method specific for this
   * token's type.
   *
   * @param visitor the {@link CqnVisitor}
   */
  void accept(CqnVisitor visitor);

  @Beta
  default Stream<CqnToken> tokens() {
    return Stream.of(this);
  }
}
