/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import com.google.common.annotations.Beta;
import com.sap.cds.CdsVector;
import com.sap.cds.reflect.CdsBaseType;
import java.util.Optional;

@Beta
public interface CqnVector extends CqnLiteral<CdsVector> {

  @Override
  default boolean isVector() {
    return true;
  }

  @Override
  default CqnVector asVector() {
    return this;
  }

  @Override
  default Optional<String> type() {
    return Optional.of(CdsBaseType.VECTOR.cdsName());
  }

  @Override
  default boolean isConstant() {
    return false;
  }

  @Override
  default void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }
}
