/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;

/** Transformation that limits the input set to a maximum number of rows */
@Beta
public interface CqnTopTransformation extends CqnTransformation {

  /**
   * Returns the maximum number of rows to be returned
   *
   * @return the maximum number of rows to be returned or -1 if unlimited
   */
  long top();

  @Override
  default Kind kind() {
    return Kind.TOP;
  }

  @Override
  default void accept(CqnTransformationVisitor visitor) {
    visitor.visit(this);
  }
}
