/*
 * © 2019-2022 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect;

import java.util.Optional;

public interface CdsParameter extends CdsAnnotatable {

  /**
   * Returns the name of this {@code CdsParameter}.
   *
   * @return the name of this parameter, not {@code null}
   */
  String getName();

  /**
   * Returns the type of this {@code CdsParameter}.
   *
   * @return the type of this parameter, not {@code null}
   */
  CdsType getType();

  /**
   * Returns an {@link Optional} wrapping the default value of this {@code CdsParameter}.
   *
   * @return an {@code Optional} describing the default value of the {@code CdsParameter}, or an
   *     empty {@code Optional} if there is no default value
   */
  Optional<Object> getDefaultValue();

  /**
   * Accepts a {@link CdsVisitor} visiting this type.
   *
   * @param visitor the {@code CdsVisitor}
   */
  default void accept(CdsVisitor visitor) {
    visitor.visit(this);
  }

  /**
   * Returns true if this parameter cannot be null
   *
   * @return true if this parameter cannot be null, otherwise false
   */
  boolean isNotNull();
}
