/*
 * © 2018-2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.transaction.spi;

import java.sql.Connection;
import java.util.function.Supplier;

/**
 * Factory for a transaction manager
 *
 * @param <DS> the data source type
 */
public interface TransactionManagerFactory<DS> {

  /**
   * Creates or gets a singleton instance of a transaction manager
   *
   * @return the singleton instance
   */
  ContainerTransactionManager getTransactionManger();

  /**
   * Get the data source managed by the singleton instance of the transaction manager
   *
   * @return the managed data source
   */
  Supplier<Connection> getConnectionSupplier();
}
