/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public final class UserContext {
    private String id;
    private Locale locale;
    private TimeZone timeZone = TimeZone.getDefault();
    private String tenant;
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    private UserContext() {
    }

    public static UserContext create() {
        return new UserContext();
    }

    public UserContext from(UserContext userCtx) {
        this.setId(userCtx.getId());
        this.setLocale(userCtx.getLocale());
        this.setTenant(userCtx.getTenant());
        this.setAttributes(userCtx.getAttributes());
        return this;
    }

    public UserContext setId(String id) {
        this.id = id;
        return this;
    }

    public UserContext setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public UserContext setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public UserContext setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public UserContext setAttributes(Map<String, List<String>> attributes) {
        this.attributes = Objects.isNull(attributes) ? new HashMap<String, List<String>>() : attributes;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getTenant() {
        return this.tenant;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttribute(String name) {
        return this.attributes.get(name);
    }
}

