/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds;

import java.io.Serial;

/** Exception thrown when an operation fails because of missing value. */
public class CdsMissingValueException extends CdsException {
  @Serial private static final long serialVersionUID = 1L;
  private String elementName;

  public CdsMissingValueException(String elementName) {
    super("Missing value for parameter %s".formatted(elementName));
    this.elementName = elementName;
  }

  public CdsMissingValueException(String message, Throwable e) {
    super(message, e);
  }

  public String getElementName() {
    return elementName;
  }
}
