/*
 * © 2018-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds;

/**
 * Represents the generic {@link Row} based result data returned by the {@link CdsDataStore}. {@link
 * Result} can be serialized to JSON and accessed as an {@link Iterable} of {@link Row} or in a
 * typed way via an explicitly given accessor interface.
 */
public interface Result extends CdsResult<Row> {

  /**
   * Converts the given (typed) {@link CdsResult} to an untyped {@link Result}.
   *
   * @param result the (typed) {@link CdsResult}
   * @return the untyped {@link Result}
   */
  public static Result of(CdsResult<?> result) {
    if (result instanceof Result r) {
      return r;
    } else if (result instanceof TypedResult tr) {
      return tr.asResult();
    }
    throw new IllegalArgumentException(
        "Unsupported CdsResult type: " + result.getClass().getName());
  }
}
