/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds;

import com.sap.cds.reflect.CdsStructuredType;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * A wrapper around the {@link Row} based {@link Result} to type it by default with a (generated)
 * accessor interface.
 */
class TypedResult<D extends CdsData> implements CdsResult<D> {

  private final Result result;
  private final Class<D> clazz;

  TypedResult(Result result, Class<D> clazz) {
    this.result = result;
    this.clazz = clazz;
  }

  @Override
  public D single() {
    return result.single(clazz);
  }

  @Override
  public <T> T single(Class<T> type) {
    return result.single(type);
  }

  @Override
  public Optional<D> first() {
    return result.first(clazz);
  }

  @Override
  public <T> Optional<T> first(Class<T> type) {
    return result.first(type);
  }

  @Override
  public Stream<D> stream() {
    return result.streamOf(clazz);
  }

  @Override
  public <T> Stream<T> streamOf(Class<T> type) {
    return result.streamOf(type);
  }

  @Override
  public List<D> list() {
    return result.listOf(clazz);
  }

  @Override
  public <T> List<T> listOf(Class<T> type) {
    return result.listOf(type);
  }

  @Override
  public Iterator<D> iterator() {
    return streamOf(clazz).iterator();
  }

  @Override
  public String toJson() {
    return result.toJson();
  }

  @Override
  public CdsStructuredType rowType() {
    return result.rowType();
  }

  @Override
  public long rowCount() {
    return result.rowCount();
  }

  @Override
  public long rowCount(int batch) {
    return result.rowCount(batch);
  }

  @Override
  public int batchCount() {
    return result.batchCount();
  }

  @Override
  public long inlineCount() {
    return result.inlineCount();
  }

  Result asResult() {
    return result;
  }
}
