/*
 * © 2018-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;

public interface BooleanFunction extends Predicate, CqnFunc {

  BooleanFunction args(CqnValue... args);

  @Override
  default void accept(CqnVisitor visitor) {
    args().forEach(a -> a.accept(visitor));
    visitor.visit((CqnFunc) this);
  }
}
