/*
 * © 2018-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.List;
import java.util.stream.Stream;

public interface FunctionCall<T> extends Value<T>, CqnFunc {

  FunctionCall<T> args(CqnValue... args);

  /**
   * Create a window function from this function call over a window with given partitions
   *
   * @param partitions the partitions
   * @return the window function created from this function call
   */
  WindowFunctionCall<T> over(List<? extends CqnValue> partitions);

  /**
   * Create a window function from this function call over a window with given partitions
   *
   * @param partitions the partitions
   * @return the window function created from this function call
   */
  WindowFunctionCall<T> over(CqnValue... partitions);

  /**
   * Create a window function from this function call over a window with given partitions
   *
   * @param partitions the partitions
   * @return the window function created from this function call
   */
  WindowFunctionCall<T> over(String... partitions);

  /**
   * Create a window function from this function call over a window with a single partition
   *
   * @return the window function created from this function call
   */
  default WindowFunctionCall<T> over() {
    return over(List.<CqnValue>of());
  }

  /**
   * Create a window function from this function call over a window with given partitions
   *
   * @param partitions the partitions
   * @return the window function created from this function call
   */
  WindowFunctionCall<T> over(Stream<? extends CqnValue> partitions);

  @Override
  <U> FunctionCall<U> type(String cdsType);
}
