/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql;

import com.sap.cds.CdsData;
import com.sap.cds.CdsResult;

/**
 * A {@link StructuredType} that is linked with its corresponding {@link CdsData} type. Using this
 * interface allows returning a typed {@link CdsResult}.
 */
public interface LinkedStructuredType<D extends CdsData, T extends StructuredType<T>>
    extends StructuredType<T> {

  /**
   * @return the (generated) {@link CdsData} sub interface that is the linked accessor interface for
   *     this {@link StructuredType}
   */
  Class<D> getCdsDataClass();
}
