/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

public interface CqnContainmentTest extends CqnPredicate, CqnFunc {
  Position position();

  CqnValue value();

  CqnValue term();

  boolean caseInsensitive();

  @Override
  default void accept(CqnVisitor visitor) {
    value().accept(visitor);
    term().accept(visitor);

    visitor.visit(this);
  }

  enum Position {
    /** Checks if the value starts with the term. */
    START("startsWith"),
    /** Checks if the value ends with the term. */
    END("endsWith"),
    /** Checks if the value contains the term. */
    ANY("contains"),
    /**
     * Checks if the value matches the term.
     *
     * <p>Supports wildcards '*' matching zero or more characters and '?' matching a single
     * character.
     */
    MATCH("matching"),
    /**
     * Behaves like {@link #MATCH}, if the term contains wildcards ('*' and '?'). Behaves like
     * {@link #ANY}, if the term does not contain wildcards.
     */
    SEARCH("search");

    private final String func;

    Position(String func) {
      this.func = func;
    }

    public String func() {
      return func;
    }
  }
}
