/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import com.google.common.annotations.Beta;

/** Predicate that tests whether eTag element of an entity matches any value */
@Beta
public interface CqnEtagPredicate extends CqnInPredicate {

  String ANY = "*";
  String $ETAG = "$etag";

  @Override
  default void accept(CqnVisitor visitor) {
    value().accept(visitor);
    valueSet().accept(visitor);

    visitor.visit(this);
  }
}
