/*
 * © 2018-2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

public interface CqnExistsSubquery extends CqnPredicate {

  String OUTER = "$outer";

  public CqnSelect subquery();

  /**
   * Dispatches the handling of this {@code CqnExistsSubquery} to a given visitor.
   *
   * <p>The subquery is not traversed.
   *
   * @param visitor the {@link CqnVisitor}
   */
  @Override
  default void accept(CqnVisitor visitor) {
    visitor.visit(this);
  }
}
