/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

/**
 * The {@code in} subquery predicate tests wether an {@link #value() actual value} (n-tuple) is
 * equal to any value (n-tuple) returned by a defined {@link #subquery() subquery}.
 *
 * <p>It evaluates to {@code false} if the subquery has an empty result.
 */
public interface CqnInSubquery extends CqnPredicate {

  /**
   * The actual {@link CqnValue} (n-tuple) that is being compared to the result set (n-tuples) of
   * the {@link #subquery()}.
   *
   * @return the actual {@link CqnValue}
   */
  CqnValue value();

  /**
   * The subquery that defines the set of expected values the {@link #value() actual value} is
   * tested against.
   *
   * @return the subquery
   */
  CqnSelect subquery();

  @Override
  default void accept(CqnVisitor visitor) {
    value().accept(visitor);

    visitor.visit(this);
  }
}
