/*
 * © 2018-2023 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn;

import java.util.Optional;
import java.util.stream.Stream;

public interface CqnSelectListValue extends CqnSelectListItem {

  CqnValue value();

  /**
   * Returns display name of this select list value. It is the name of the element of the underlying
   * entity or the alias.
   *
   * @return the display name as a string
   */
  String displayName();

  Optional<String> alias();

  @Override
  default boolean isValue() {
    return true;
  }

  @Override
  default CqnSelectListValue asValue() {
    return this;
  }

  @Override
  default Stream<CqnSelectListValue> ofValue() {
    return Stream.of(this);
  }

  @Override
  default boolean isRef() {
    return value().isRef();
  }

  @Override
  default CqnElementRef asRef() {
    return value().asRef();
  }

  @Override
  default Stream<CqnElementRef> ofRef() {
    return value().ofRef();
  }

  @Override
  default void accept(CqnVisitor visitor) {
    value().accept(visitor);

    visitor.visit(this);
  }
}
