/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;

/**
 * Transformation that determines ancestors of instances that belong to a recursive hierarchy.
 *
 * <p>The hierarchy is defined by the {@link #hierarchyReference() hierarchy reference} and the
 * {@link #hierarchyQualifier() hierarchy qualifier}.
 *
 * <p>The transformation takes an input set consisting of instances that belong to the hierarchy. It
 * firstly determines a subset <i>A</i> of the input set by applying {@link #transformations()
 * transformations} - typically {@link CqnFilterTransformation filter} or {@link
 * CqnSearchTransformation search} - to the input set. Then it determines the set of ancestors of
 * <i>A</i> that were already contained in the input set. Its output set is the ancestors set,
 * {@link #keepStart() optionally} including <i>A</i>.
 */
@Beta
public interface CqnAncestorsTransformation extends CqnHierarchySubsetTransformation {

  @Override
  default Kind kind() {
    return Kind.ANCESTORS;
  }

  @Override
  default void accept(CqnTransformationVisitor visitor) {
    visitor.visit(this);
  }
}
