/*
 * © 2018-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import java.util.List;

/** Transformation that adds additional computed elements to the input set */
@Beta
public interface CqnComputeTransformation extends CqnTransformation {

  /**
   * Returns the additional computed elements specified as select list values
   *
   * @return the additional elements
   */
  List<CqnSelectListValue> computedItems();

  @Override
  default Kind kind() {
    return Kind.COMPUTE;
  }

  @Override
  default void accept(CqnTransformationVisitor visitor) {
    visitor.visit(this);
  }
}
