/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;
import java.util.List;

@Beta
public interface CqnHierarchySubsetTransformation extends CqnHierarchyTransformation {

  /**
   * Returns the transformations, which are applied to the input set before the
   * ancestors/descendants are determined.
   *
   * <p>Typically, a {@link CqnFilterTransformation filter} or a {@link CqnSearchTransformation
   * search} transformation is applied.
   *
   * @return the transformations
   */
  List<CqnTransformation> transformations();

  /**
   * Returns the maximum distance between start nodes and ancestors or descendants
   *
   * @return the maximum distance between start nodes and ancestors or descendants
   */
  int distanceFromStart();

  /**
   * Returns whether the start nodes, i.e. the nodes after applying the {@link #transformations()
   * transformations}, should be included
   *
   * @return {@code true}, if the start nodes should be include; {@code false}, otherwise
   */
  boolean keepStart();
}
