/*
 * © 2018-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.ql.cqn.transformation;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import java.util.List;

/** Transformation that sorts the input set */
@Beta
public interface CqnOrderByTransformation extends CqnTransformation {

  /**
   * Returns the sort specifications by which the input set is sorted
   *
   * @return the sort specifications
   */
  List<CqnSortSpecification> orderBy();

  @Override
  default Kind kind() {
    return Kind.ORDERBY;
  }

  @Override
  default void accept(CqnTransformationVisitor visitor) {
    visitor.visit(this);
  }
}
