/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect;

import java.util.Optional;
import java.util.stream.Stream;

public interface CdsOperation extends CdsDefinition {

  /**
   * Returns a sequential {@code Stream} over the {@link CdsParameter CdsParameter(s)} of this
   * {@code CdsAction}.
   *
   * @return a sequential {@code Stream} over the {@code CdsParameter(s)}
   */
  Stream<CdsParameter> parameters();

  /**
   * Returns an {@link Optional} wrapping the {@link CdsType} of this {@code CdsOperation}.
   *
   * @return an {@code Optional} describing the {@code CdsType} of this definition, or an empty
   *     {@code Optional} if the operation does not have a return type
   */
  default Optional<CdsType> returnType() {
    return returns().map(CdsParameter::getType);
  }

  /**
   * Returns an {@link Optional} wrapping the return {@link CdsParameter parameter} of this {@code
   * CdsOperation}.
   *
   * @return an {@code Optional} describing the return {@code CdsParameter parameter} of this
   *     definition, or an empty {@code Optional} if the operation does not have a return definition
   */
  Optional<CdsParameter> returns();
}
