/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.reflect.overlay;

import com.google.common.annotations.Beta;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import java.util.Map;

/** The {@code CdsElementExtender} allows to define and extend the underlying {@link CdsElement}. */
@Beta
public interface CdsElementExtender {

  /**
   * Sets the type for the element.
   *
   * @param baseType the base type
   * @return this {@code CdsElementExtender}
   * @throws IllegalStateException if the element is typed already
   */
  CdsElementExtender type(CdsBaseType baseType);

  /**
   * Sets the type for the element.
   *
   * @param baseType the base type
   * @param properties base type properties
   * @return this {@code CdsElementExtender}
   * @throws IllegalStateException if the element is typed already
   */
  CdsElementExtender type(CdsBaseType baseType, Map<String, Object> properties);

  /**
   * Adds an annotation to the element.
   *
   * @param key the annotation key
   * @param value the annotation value
   * @return this {@code CdsElementExtender}
   */
  CdsElementExtender addAnnotation(String key, Object value);

  /**
   * Returns to the {@code CdsEntityExtender} that created this {@code CdsElementExtender}.
   *
   * @return the parent {@code CdsEntityExtender} to continue extending the entity
   */
  CdsEntityExtender and();
}
