/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.cqn;

import com.google.common.annotations.Beta;
import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedRefItem;
import com.sap.cds.reflect.CdsModel;
import java.util.function.Supplier;

public final class CqnAnalyzer {
    private static final CqnAnalyzerSPI analyzer = Cds4jServiceLoader.load(CqnAnalyzerSPI.class);
    private final Supplier<CdsModel> modelSupplier;

    private CqnAnalyzer(Supplier<CdsModel> modelSupplier) {
        this.modelSupplier = modelSupplier;
    }

    public static boolean isCountQuery(CqnStatement cqn) {
        return analyzer.isCountQuery(cqn);
    }

    public static CqnAnalyzer create(CdsModel model) {
        return CqnAnalyzer.create(() -> model);
    }

    public static CqnAnalyzer create(Supplier<CdsModel> modelSupplier) {
        return new CqnAnalyzer(modelSupplier);
    }

    public AnalysisResult analyze(CqnStructuredTypeRef ref) {
        return analyzer.analyze(this.modelSupplier.get(), ref);
    }

    public AnalysisResult analyze(CqnFilterableStatement statement) {
        return analyzer.analyze(this.modelSupplier.get(), statement);
    }

    @Beta
    public Iterable<ResolvedRefItem> resolveRefItems(CqnSelect query) {
        return analyzer.resolveRefItems(this.modelSupplier.get(), query);
    }

    public static interface CqnAnalyzerSPI {
        public AnalysisResult analyze(CdsModel var1, CqnStructuredTypeRef var2);

        public AnalysisResult analyze(CdsModel var1, CqnFilterableStatement var2);

        public Iterable<ResolvedRefItem> resolveRefItems(CdsModel var1, CqnSelect var2);

        public boolean isCountQuery(CqnStatement var1);
    }
}

