/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect;

import com.sap.cds.CdsData;
import com.sap.cds.CdsException;
import com.sap.cds.CdsVector;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum CdsBaseType {
    UUID("cds.UUID", String.class),
    BOOLEAN("cds.Boolean", Boolean.class),
    INTEGER("cds.Integer", Integer.class),
    UINT8("cds.UInt8", Short.class),
    INT16("cds.Int16", Short.class),
    INT32("cds.Int32", Integer.class),
    INT64("cds.Int64", Long.class),
    INTEGER64("cds.Integer64", Long.class),
    DECIMAL("cds.Decimal", BigDecimal.class),
    DECIMAL_FLOAT("cds.DecimalFloat", BigDecimal.class),
    DOUBLE("cds.Double", Double.class),
    DATE("cds.Date", LocalDate.class),
    TIME("cds.Time", LocalTime.class),
    DATETIME("cds.DateTime", Instant.class),
    TIMESTAMP("cds.Timestamp", Instant.class),
    STRING("cds.String", String.class),
    BINARY("cds.Binary", byte[].class),
    LARGE_STRING("cds.LargeString", String.class),
    LARGE_BINARY("cds.LargeBinary", byte[].class),
    VECTOR("cds.Vector", CdsVector.class),
    MAP("cds.Map", CdsData.class),
    HANA_SMALLINT("cds.hana.SMALLINT", Short.class),
    HANA_TINYINT("cds.hana.TINYINT", Short.class),
    HANA_SMALLDECIMAL("cds.hana.SMALLDECIMAL", BigDecimal.class),
    HANA_REAL("cds.hana.REAL", Float.class),
    HANA_CHAR("cds.hana.CHAR", String.class),
    HANA_NCHAR("cds.hana.NCHAR", String.class),
    HANA_VARCHAR("cds.hana.VARCHAR", String.class),
    HANA_CLOB("cds.hana.CLOB", String.class),
    HANA_BINARY("cds.hana.BINARY", byte[].class),
    HANA_ST_POINT("cds.hana.ST_POINT", byte[].class),
    HANA_ST_GEOMETRY("cds.hana.ST_GEOMETRY", byte[].class),
    UNDEFINED("undefined", Object.class);

    private static final Map<String, CdsBaseType> reverse;
    private final String cdsName;
    private final Class<?> javaType;

    private CdsBaseType(String cdsName, Class<?> javaType) {
        this.cdsName = cdsName;
        this.javaType = javaType;
    }

    public String cdsName() {
        return this.cdsName;
    }

    public Class<?> javaType() {
        return this.javaType;
    }

    public String toString() {
        return this.cdsName;
    }

    public static CdsBaseType cdsType(String cdsName) {
        return reverse.getOrDefault(cdsName, UNDEFINED);
    }

    public static Class<?> cdsJavaMediaType(CdsBaseType cdsType) {
        switch (cdsType) {
            case HANA_CLOB: 
            case STRING: 
            case LARGE_STRING: {
                return Reader.class;
            }
            case LARGE_BINARY: {
                return InputStream.class;
            }
        }
        throw new CdsException("@Core.MediaType is not supported for type " + String.valueOf((Object)cdsType));
    }

    static {
        reverse = Arrays.stream(CdsBaseType.values()).collect(Collectors.toMap(CdsBaseType::cdsName, t -> t));
    }
}

