/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.google.common.collect.Streams;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.EntityWriterException;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.generator.writer.CreateBuilderInterfaceVisitor;
import com.sap.cds.generator.writer.CreateConsumptionInterfaceVisitor;
import com.sap.cds.generator.writer.CreateEventContextInterfaceVisitor;
import com.sap.cds.generator.writer.WrapperInterfaceCreator;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsVisitor;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

public class ModelWriter
implements CdsVisitor {
    private static final String CONTEXT_SUFFIX = "Context";
    private final GeneratedFile.Consumer consumer;
    private final Configuration config;
    private final CdsModel model;
    private final Map<String, CdsDefinition> wrapperMap;
    private final boolean isEventContext;

    public ModelWriter(GeneratedFile.Consumer consumer, Configuration config, CdsModel model) {
        this.consumer = consumer;
        this.config = config;
        this.model = model;
        this.wrapperMap = new HashMap<String, CdsDefinition>();
        this.isEventContext = Boolean.parseBoolean(config.getEventContext());
    }

    public void visit(CdsModel model) {
        this.wrapperMap.values().forEach(this::generateWrapperInterface);
    }

    public void visit(CdsEntity entity) {
        NamesUtils.checkForJavaKeyword(entity.getQualifiedName());
        if (!this.isExcluded(entity.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)entity);
            this.generateBuilderInterface(entity);
            this.generateConsumptionInterface((CdsDefinition)entity, entity.getQualifiedName());
            if (this.isEventContext) {
                Streams.concat((Stream[])new Stream[]{entity.actions(), entity.functions()}).forEach(a -> this.generateEventContextInterface((CdsDefinition)a, entity.getQualifiedName(), true));
            }
        }
    }

    public void visit(CdsEvent event) {
        NamesUtils.checkForJavaKeyword(event.getQualifiedName());
        if (!this.isExcluded(event.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)event);
            this.generateConsumptionInterface((CdsDefinition)event, event.getQualifiedName());
            if (this.isEventContext) {
                this.generateEventContextInterface((CdsDefinition)event, event.getQualifiedName(), false);
            }
        }
    }

    public void visit(CdsAction action) {
        if (this.isEventContext && !this.isExcluded(action.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)action);
            this.generateEventContextInterface((CdsDefinition)action, action.getQualifiedName(), false);
        }
    }

    public void visit(CdsFunction function) {
        if (this.isEventContext && !this.isExcluded(function.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)function);
            this.generateEventContextInterface((CdsDefinition)function, function.getQualifiedName(), false);
        }
    }

    private boolean isExcluded(String qualifiedName) {
        List<String> excludes = this.config.getExcludes();
        boolean excluded = false;
        int i = qualifiedName.lastIndexOf(46);
        if (i > 0) {
            String namespace = qualifiedName.substring(0, i);
            excluded = excludes.stream().filter(e -> !e.contains("*")).anyMatch(e -> e.equals(namespace));
        }
        if (!excluded) {
            excluded = excludes.stream().filter(e -> e.contains("*")).anyMatch(qualifiedName::matches);
        }
        return excluded;
    }

    public void visit(CdsStructuredType struct) {
        NamesUtils.checkForJavaKeyword(struct.getQualifiedName());
        if (!this.isExcluded(struct.getQualifiedName())) {
            this.generateConsumptionInterface((CdsDefinition)struct, struct.getQualifiedName());
        }
    }

    private void collectWrapperInterfaces(CdsDefinition entity) {
        String packageName = NamesUtils.javaPackage(this.config.getBasePackage(), entity.getQualifiedName());
        this.wrapperMap.put(packageName, entity);
    }

    private void generateWrapperInterface(CdsDefinition entity) {
        String qualifiedName = entity.getQualifiedName();
        String packageName = NamesUtils.javaPackage(this.config.getBasePackage(), qualifiedName);
        String contextClassName = CaseFormatHelper.toUpperCamel(NamesUtils.unqualifiedContextName(qualifiedName)) + this.config.getClassNameSuffix();
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(contextClassName);
        if (WrapperInterfaceCreator.create(builder, this.model, this.config).generateInterface(NamesUtils.namespace(qualifiedName))) {
            this.writeType(packageName, builder.build());
        }
    }

    private void generateConsumptionInterface(CdsDefinition def, String qualifiedName) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(CaseFormatHelper.toUpperCamel(def.getName()));
        def.accept(CreateConsumptionInterfaceVisitor.create(builder, this.config, qualifiedName));
        Optional parentAnnotation = def.findAnnotation("@cds.java.extends".substring(1));
        parentAnnotation.ifPresent(annotation -> {
            ArrayList baseEntities = (ArrayList)annotation.getValue();
            for (String baseEntityName : baseEntities) {
                CdsEntity baseEntity = this.model.getEntity(baseEntityName);
                String packageNameForBase = NamesUtils.javaPackage(this.config.getBasePackage(), baseEntity.getQualifiedName());
                builder.addSuperinterface((TypeName)ClassName.get((String)packageNameForBase, (String)baseEntity.getName(), (String[])new String[0]));
            }
        });
        TypeSpec typeSpec = builder.build();
        String packageName = NamesUtils.javaPackage(this.config.getBasePackage(), qualifiedName);
        this.writeType(packageName, typeSpec);
    }

    private void generateEventContextInterface(CdsDefinition def, String qualifiedName, boolean bounded) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(CaseFormatHelper.toUpperCamel(def.getName() + CONTEXT_SUFFIX));
        def.accept(CreateEventContextInterfaceVisitor.create(builder, this.config, qualifiedName, bounded));
        TypeSpec typeSpec = builder.build();
        String packageName = NamesUtils.javaPackage(this.config.getBasePackage(), qualifiedName);
        this.writeType(packageName, typeSpec);
    }

    private void generateBuilderInterface(CdsEntity entity) {
        String interfaceName = NamesUtils.qualifiedJavaClass(this.config.getBasePackage(), entity.getName()) + this.config.getClassNameSuffix();
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(interfaceName);
        entity.accept(CreateBuilderInterfaceVisitor.create(builder, this.config));
        TypeSpec typeSpec = builder.build();
        String packageName = NamesUtils.javaPackage(this.config.getBasePackage(), entity.getQualifiedName());
        this.writeType(packageName, typeSpec);
    }

    private static TypeSpec.Builder createInterfaceSpecBuilder(String clazz) {
        String unqualifiedClassName = NamesUtils.unqualifiedName(clazz);
        return TypeSpec.interfaceBuilder((String)unqualifiedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private void writeType(String packageName, TypeSpec typeSpec) {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        final JavaFileObject fileObject = javaFile.toJavaFileObject();
        GeneratedFile jpaFile = new GeneratedFile(){

            @Override
            public URI getUri() {
                return fileObject.toUri();
            }

            @Override
            public InputStream getContent() throws IOException {
                return fileObject.openInputStream();
            }
        };
        try {
            this.consumer.accept(jpaFile);
        }
        catch (IOException e) {
            String message = String.format("Exception while writing to file %s.", jpaFile.getUri());
            throw new EntityWriterException(message, e);
        }
    }
}

