/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Locale;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesUtils {
    private static final Logger logger = LoggerFactory.getLogger(NamesUtils.class);

    private NamesUtils() {
    }

    public static String javaPackage(String basePackage, String qualifiedName) {
        String packageName = NamesUtils.namespace(qualifiedName);
        if (!Strings.isNullOrEmpty((String)basePackage)) {
            packageName = Joiner.on((char)'.').skipNulls().join((Object)basePackage, (Object)packageName, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)packageName)) {
            packageName = "model";
        }
        return packageName == null ? "" : packageName.toLowerCase(Locale.US);
    }

    public static String namespace(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return null;
    }

    public static String unqualifiedName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        return qualifiedName.substring(lastDot + 1);
    }

    public static String unqualifiedContextName(String qualifiedName) {
        if (qualifiedName.contains(".")) {
            String[] bits = qualifiedName.split("\\.");
            return bits[bits.length - 2];
        }
        return "CdsModel";
    }

    public static String qualifiedJavaClass(String basePackage, String entityName) {
        String packageName = NamesUtils.javaPackage(basePackage, entityName);
        String name = NamesUtils.unqualifiedName(entityName);
        return packageName + "." + CaseFormatHelper.toUpperCamel(name);
    }

    public static void checkForJavaKeyword(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            String[] split;
            for (String word : split = qualifiedName.split("\\.")) {
                if (!SourceVersion.isKeyword(word)) continue;
                logger.warn("The Entity " + qualifiedName + " contains a reserved Java keyword in its fully qualified name.");
            }
        }
    }

    public static TypeName getAttributeType(CdsType type, Configuration cfg) {
        TypeName attributeType;
        if (type.isAssociation()) {
            String targetName = ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget().getQualifiedName();
            attributeType = PoetTypeName.getTypeFromCdsName(cfg.getBasePackage(), targetName);
            if (!CdsModelUtils.isSingleValued((CdsType)type)) {
                attributeType = NamesUtils.listOf(attributeType);
            }
        } else if (type.isSimple()) {
            attributeType = PoetTypeName.getTypeName(((CdsSimpleType)type.as(CdsSimpleType.class)).getJavaType().getTypeName());
        } else if (type.isStructured()) {
            String targetName = type.getQualifiedName();
            attributeType = PoetTypeName.getTypeFromCdsName(cfg.getBasePackage(), targetName);
        } else if (type.isArrayed()) {
            CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
            TypeName innerAttributeType = NamesUtils.getAttributeType(itemsType, cfg);
            if (innerAttributeType.toString().endsWith(".")) {
                String className = CaseFormatHelper.toUpperCamel(NamesUtils.unqualifiedName(type.getQualifiedName()));
                TypeName outer = PoetTypeName.getTypeFromCdsName(cfg.getBasePackage(), NamesUtils.namespace(type.getQualifiedName()));
                attributeType = PoetTypeName.getArrayTypeName(PoetTypeName.getTypeName(outer + "." + className));
            } else {
                attributeType = PoetTypeName.getArrayTypeName(innerAttributeType);
            }
        } else {
            logger.warn("Interface Generation: Unsupported CDS Element with attribute name '" + type.getName() + "' and type '" + type + "'");
            return null;
        }
        return attributeType;
    }

    public static TypeName getReturnType(CdsElement attribute, Configuration cfg) {
        boolean isMedia = attribute.annotations().anyMatch(a -> "Core.MediaType".equals(a.getName()));
        if (isMedia && attribute.getType().isSimple()) {
            CdsSimpleType simpleType = (CdsSimpleType)attribute.getType().as(CdsSimpleType.class);
            return PoetTypeName.getTypeName(CdsBaseType.cdsJavaMediaType((CdsBaseType)simpleType.getType()).getName());
        }
        if (attribute.getType().isStructured() && attribute.getType().getQualifiedName().isEmpty()) {
            return PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(attribute.getName()));
        }
        return NamesUtils.getAttributeType(attribute.getType(), cfg);
    }

    public static ParameterizedTypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{type});
    }
}

