/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.sap.cds.generator.util.EntityWriterException;
import com.sap.cds.generator.util.NamesUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;

public class PoetTypeName {
    private PoetTypeName() {
    }

    public static TypeName getTypeFromCdsName(String basePackage, String cdsName) {
        return PoetTypeName.getTypeName(NamesUtils.qualifiedJavaClass(basePackage, cdsName));
    }

    public static TypeName getTypeName(String javaType) {
        switch (javaType) {
            case "boolean": {
                return TypeName.BOOLEAN;
            }
            case "byte": {
                return TypeName.BYTE;
            }
            case "byte[]": {
                return TypeName.get(byte[].class);
            }
            case "short": {
                return TypeName.SHORT;
            }
            case "int": {
                return TypeName.INT;
            }
            case "long": {
                return TypeName.LONG;
            }
            case "char": {
                return TypeName.CHAR;
            }
            case "float": {
                return TypeName.FLOAT;
            }
            case "double": {
                return TypeName.DOUBLE;
            }
        }
        try {
            int i = javaType.lastIndexOf(46);
            if (i > 0) {
                String packageName = javaType.substring(0, i);
                String className = javaType.substring(i + 1);
                return ClassName.get((String)packageName, (String)className, (String[])new String[0]);
            }
            if (null != ClassName.get((String)"", (String)javaType, (String[])new String[0])) {
                return ClassName.get((String)"", (String)javaType, (String[])new String[0]);
            }
            return ClassName.bestGuess((String)javaType);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Failed to resolve type: %s.", javaType);
            throw new EntityWriterException(message, e);
        }
    }

    public static TypeName getArrayTypeName(TypeName javaType) {
        ClassName set = ClassName.get(Collection.class);
        ParameterizedTypeName setWithParameter = ParameterizedTypeName.get((ClassName)set, (TypeName[])new TypeName[]{javaType});
        return setWithParameter;
    }
}

