/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuilderInterfaceVisitor
implements CdsVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CreateBuilderInterfaceVisitor.class);
    private static final String FILTER = "filter";
    private final TypeSpec.Builder entityClass;
    private final Configuration cfg;
    private String entityName;

    private CreateBuilderInterfaceVisitor(TypeSpec.Builder builder, Configuration cfg) {
        this.entityClass = builder;
        this.cfg = cfg;
    }

    public static CdsVisitor create(TypeSpec.Builder builder, Configuration cfg) {
        return new CreateBuilderInterfaceVisitor(builder, cfg);
    }

    public void visit(CdsEntity entity) {
        String interfaceName = NamesUtils.qualifiedJavaClass(this.cfg.getBasePackage(), entity.getQualifiedName()) + this.cfg.getClassNameSuffix();
        TypeName type = PoetTypeName.getTypeName(NamesUtils.unqualifiedName(interfaceName));
        this.entityClass.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.STRUCTUREDTYPE, (TypeName[])new TypeName[]{type}));
        this.entityClass.addAnnotation(AnnotationSpec.builder(CdsName.class).addMember("value", "$S", new Object[]{entity.getQualifiedName()}).build());
        this.addStaticQualifiedAttribute(entity);
        this.entityName = entity.getName();
    }

    public void visit(CdsElement attribute) {
        if (!attribute.getType().isAssociation()) {
            this.addAttribute(attribute);
        } else {
            this.addAssociationAttribute(attribute);
        }
    }

    private void addStaticQualifiedAttribute(CdsEntity entity) {
        String qualifiedName = entity.getQualifiedName();
        FieldSpec staticField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{qualifiedName}).build();
        this.entityClass.addField(staticField);
    }

    private void addAssociationAttribute(CdsElement attribute) {
        this.addMainFunction(attribute);
        this.addFilterFunction(attribute);
    }

    private void addAttribute(CdsElement attribute) {
        String attributeName = (String)attribute.getAnnotationValue(CdsAnnotatableImpl.removeAt((String)"@cds.java.name"), (Object)attribute.getName());
        TypeName type = NamesUtils.getReturnType(attribute, this.cfg);
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)Types.REFERENCE, (TypeName[])new TypeName[]{type});
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)attributeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType);
        boolean addCdsNameAnnotation = SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute.getName(), attributeName);
        if (addCdsNameAnnotation) {
            SpecWriterUtil.addStaticField(this.entityClass, attribute);
        }
        this.entityClass.addMethod(methodBuilder.build());
    }

    private void addMainFunction(CdsElement attribute) {
        CdsAssociationType association = (CdsAssociationType)attribute.getType();
        String targetEntityClassName = this.interfaceName(association.getTarget());
        TypeName returnType = PoetTypeName.getTypeName(targetEntityClassName);
        this.entityClass.addMethod(MethodSpec.methodBuilder((String)attribute.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(returnType).build());
    }

    private void addFilterFunction(CdsElement attribute) {
        if (!attribute.getName().equalsIgnoreCase(FILTER)) {
            CdsAssociationType association = (CdsAssociationType)attribute.getType();
            String targetEntityClassName = this.interfaceName(association.getTarget());
            TypeName returnType = PoetTypeName.getTypeName(targetEntityClassName);
            this.entityClass.addMethod(MethodSpec.methodBuilder((String)attribute.getName()).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{returnType, Types.PREDICATE}), FILTER, new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(returnType).build());
        } else {
            logger.warn("There is a name clash between the element 'filter' of entity '" + this.entityName + "' and a method in the super interface StructuredType. A filter function accepting predicates will not be generated.");
        }
    }

    public String interfaceName(CdsEntity entity) {
        return NamesUtils.qualifiedJavaClass(this.cfg.getBasePackage(), entity.getQualifiedName()) + this.cfg.getClassNameSuffix();
    }
}

