package com.sap.cds.generator.writer;

import static com.sap.cds.generator.writer.CaseFormatHelper.lowercaseFirst;
import static com.sap.cds.generator.writer.CaseFormatHelper.toUpperUnderscore;

import javax.lang.model.element.Modifier;

import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsElement;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;

public class SpecWriterUtil {

	public static boolean addCdsNameAnnotation(MethodSpec.Builder builder, String cdsName, String javaName) {
		boolean addCdsNameAnnotation = !cdsName.equals(propertyName(javaName));
		if (addCdsNameAnnotation) {
			builder.addAnnotation(cdsNameAnnotation(toUpperUnderscore(cdsName), "$L"));
		}
		return addCdsNameAnnotation;
	}

	public static AnnotationSpec cdsNameAnnotation(String cdsName, String format) {
		return AnnotationSpec.builder(CdsName.class).addMember("value", format, cdsName).build();
	}

	public static void addStaticField(TypeSpec.Builder builder, CdsElement element) {
		String name = toUpperUnderscore(element.getName());
		FieldSpec staticField = FieldSpec.builder(String.class, name)
				.addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("$S", element.getName())
				.build();
		builder.addField(staticField);
	}

	private static String propertyName(String javaName) {
		if (javaName.startsWith("set") || javaName.startsWith("get")) {
			javaName = lowercaseFirst(javaName.substring(3));
		}
		return javaName;
	}
}
