/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsElement;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class SpecWriterUtil {
    public static boolean addCdsNameAnnotation(MethodSpec.Builder builder, String cdsName, String javaName) {
        boolean addCdsNameAnnotation;
        boolean bl = addCdsNameAnnotation = !cdsName.equals(SpecWriterUtil.propertyName(javaName));
        if (addCdsNameAnnotation) {
            builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(CaseFormatHelper.toUpperUnderscore(cdsName), "$L"));
        }
        return addCdsNameAnnotation;
    }

    public static AnnotationSpec cdsNameAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder(CdsName.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    public static void addStaticField(TypeSpec.Builder builder, CdsElement element) {
        String name = CaseFormatHelper.toUpperUnderscore(element.getName());
        FieldSpec staticField = FieldSpec.builder(String.class, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{element.getName()}).build();
        builder.addField(staticField);
    }

    private static String propertyName(String javaName) {
        if (javaName.startsWith("set") || javaName.startsWith("get")) {
            javaName = CaseFormatHelper.lowercaseFirst(javaName.substring(3));
        }
        return javaName;
    }
}

