/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.CdsData;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.sap.cds.util.CdsModelUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Map;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class CreateConsumptionInterfaceVisitor
implements CdsVisitor {
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), WildcardTypeName.subtypeOf(Object.class)});
    private final TypeSpec.Builder builder;
    private final Configuration cfg;
    private final String typeName;

    public static CdsVisitor create(TypeSpec.Builder builder, Configuration config, String typeName) {
        return new CreateConsumptionInterfaceVisitor(builder, config, typeName);
    }

    private CreateConsumptionInterfaceVisitor(TypeSpec.Builder builder, Configuration config, String typeName) {
        this.builder = builder;
        this.cfg = config;
        this.typeName = typeName;
        if (!builder.superinterfaces.contains(ClassName.get(CdsData.class))) {
            this.builder.addSuperinterface(CdsData.class);
        }
    }

    public void visit(CdsEntity entity) {
        this.addRefMethod(entity);
        TypeUtils.addStaticMethod(this.builder, (TypeName)TypeUtils.className(entity.getName()), new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(entity.getQualifiedName(), "$S"));
    }

    private void addRefMethod(CdsEntity entity) {
        if (!entity.isAbstract()) {
            ClassName returnType = TypeUtils.builderClassName((CdsDefinition)entity);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"ref").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.builder.addMethod(methodBuilder.build());
        }
    }

    public void visit(CdsEvent event) {
        TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(event.getName())), new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(event.getQualifiedName(), "$S"));
    }

    public void visit(CdsStructuredType struct) {
        TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(struct.getName())), new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(struct.getQualifiedName(), "$S"));
    }

    public void visit(CdsElement element) {
        SpecWriterUtil.addStaticField(this.builder, element);
        if (this.isAnonymousType(element)) {
            String unqualifiedClassName = NamesUtils.unqualifiedName(CaseFormatHelper.toUpperCamel(element.getName()));
            TypeSpec.Builder innerIntefaceBuilder = TypeSpec.interfaceBuilder((String)unqualifiedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            CdsType type = element.getType();
            Stream elements = type.isStructured() && type.getQualifiedName().isEmpty() ? ((CdsStructuredType)type.as(CdsStructuredType.class)).elements() : (type.isArrayed() ? ((CdsStructuredType)((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().as(CdsStructuredType.class)).elements() : TypeUtils.getAnonymousElements(element));
            String qualifiedElementName = NamesUtils.innerInterfaceQualifiedName(element, this.cfg.getBasePackage());
            elements.forEach(e -> e.accept(CreateConsumptionInterfaceVisitor.create(innerIntefaceBuilder, this.cfg, qualifiedElementName)));
            TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(unqualifiedClassName)), innerIntefaceBuilder);
            this.populateGetter(element, TypeUtils.getReturnType(element, this.cfg));
            this.populateSetter(element, TypeUtils.getReturnType(element, this.cfg));
            this.builder.addType(innerIntefaceBuilder.build());
        } else {
            this.getter(element);
            this.setter(element);
        }
    }

    private boolean isAnonymousType(CdsElement element) {
        CdsType type = element.getType();
        if (type.isArrayed()) {
            CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
            if (itemsType.isStructured() && itemsType.getQualifiedName().isEmpty()) {
                return true;
            }
        } else {
            if (type.isStructured() && type.getQualifiedName().isEmpty()) {
                return true;
            }
            if (TypeUtils.isAnonymousAspect(element)) {
                return true;
            }
        }
        return false;
    }

    private void setter(CdsElement attribute) {
        TypeName paramType = this.getSetterParam(attribute);
        if (paramType == null) {
            return;
        }
        this.populateSetter(attribute, paramType);
    }

    private void populateSetter(CdsElement attribute, TypeName paramType) {
        String setter;
        TypeName returnType;
        String attributeName = (String)attribute.getAnnotationValue(CdsAnnotatableImpl.removeAt((String)"@cds.java.name"), (Object)attribute.getName());
        if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
            returnType = TypeName.VOID;
            setter = "set" + CaseFormatHelper.toUpperCamel(attributeName);
        } else {
            returnType = PoetTypeName.getTypeName(this.typeName);
            setter = CaseFormatHelper.toLowerCamel(attributeName);
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)setter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(paramType, CaseFormatHelper.toLowerCamel(attributeName), new Modifier[0]);
        this.setJavaDoc(attribute, methodBuilder);
        SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute.getName(), setter);
        this.builder.addMethod(methodBuilder.build());
    }

    private TypeName getSetterParam(CdsElement element) {
        if (element.getType().isAssociation()) {
            if (CdsModelUtils.isSingleValued((CdsType)element.getType())) {
                return MAP_STR2OBJ;
            }
            return TypeUtils.listOf((TypeName)WildcardTypeName.subtypeOf((TypeName)MAP_STR2OBJ));
        }
        return TypeUtils.getReturnType(element, this.cfg);
    }

    private void getter(CdsElement attribute) {
        TypeName returnType = TypeUtils.getReturnType(attribute, this.cfg);
        if (returnType == null) {
            return;
        }
        this.populateGetter(attribute, returnType);
    }

    private void populateGetter(CdsElement attribute, TypeName returnType) {
        String attributeName = (String)attribute.getAnnotationValue(CdsAnnotatableImpl.removeAt((String)"@cds.java.name"), (Object)attribute.getName());
        String getter = this.cfg.getMethodStyle().equals((Object)MethodStyle.BEAN) ? "get" + CaseFormatHelper.toUpperCamel(attributeName) : CaseFormatHelper.toLowerCamel(attributeName);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)getter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.setJavaDoc(attribute, methodBuilder);
        SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute.getName(), getter);
        this.builder.addMethod(methodBuilder.build());
    }

    private void setJavaDoc(CdsElement attribute, MethodSpec.Builder methodBuilder) {
        if (!(attribute.getDeclaringType() instanceof CdsEventBuilder.EventProxy) && this.cfg.getDocs()) {
            SpecWriterUtil.getJavaDoc((CdsAnnotatable)attribute).ifPresent(x$0 -> methodBuilder.addJavadoc(x$0, new Object[0]));
        }
    }
}

