/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.google.common.collect.Streams;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.EntityWriterException;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.CreateBuilderInterfaceVisitor;
import com.sap.cds.generator.writer.CreateConsumptionInterfaceVisitor;
import com.sap.cds.generator.writer.CreateEventContextInterfaceVisitor;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.WrapperInterfaceCreator;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

public class ModelWriter
implements CdsVisitor {
    private static final String CONTEXT_SUFFIX = "Context";
    private final GeneratedFile.Consumer consumer;
    private final Configuration config;
    private final CdsModel model;
    private final Map<String, CdsDefinition> wrapperMap;
    private final Set<String> technicalEntities;
    private final Set<String> entitiesWithAspectContainingStruct;
    private final Set<String> builderInterfaces;
    private final boolean isEventContext;
    private final boolean readDocs;
    private final NamesUtils namesUtils;

    public ModelWriter(GeneratedFile.Consumer consumer, Configuration config, CdsModel model) {
        this.consumer = consumer;
        this.config = config;
        this.model = model;
        this.wrapperMap = new HashMap<String, CdsDefinition>();
        this.builderInterfaces = new HashSet<String>();
        this.isEventContext = Boolean.parseBoolean(config.getEventContext());
        this.namesUtils = new NamesUtils(config.getBasePackage());
        this.readDocs = config.getDocs();
        this.technicalEntities = new HashSet<String>();
        this.entitiesWithAspectContainingStruct = new HashSet<String>();
    }

    public void visit(CdsModel model) {
        this.wrapperMap.values().forEach(this::generateWrapperInterface);
    }

    public void visit(CdsEntity entity) {
        NamesUtils.checkForJavaKeyword(entity.getQualifiedName());
        if (!this.isExcluded(entity.getQualifiedName()) && NamesUtils.isValidTechnicalEntity(this.model, entity.getQualifiedName(), this.entitiesWithAspectContainingStruct)) {
            this.collectWrapperInterfaces((CdsDefinition)entity);
            this.generateBuilderInterface((CdsDefinition)entity);
            this.generateConsumptionInterface((CdsDefinition)entity);
            if (this.isEventContext) {
                Streams.concat((Stream[])new Stream[]{entity.actions(), entity.functions()}).forEach(a -> this.generateEventContextInterface((CdsDefinition)a, (CdsDefinition)entity));
            }
        }
        if (this.technicalEntities.contains(entity.getQualifiedName())) {
            this.generateBuilderInterface((CdsDefinition)entity);
        }
    }

    public void visit(CdsEvent event) {
        NamesUtils.checkForJavaKeyword(event.getQualifiedName());
        if (!this.isExcluded(event.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)event);
            this.generateConsumptionInterface((CdsDefinition)event);
            if (this.isEventContext) {
                this.generateEventContextInterface((CdsDefinition)event, null);
            }
        }
    }

    public void visit(CdsAction action) {
        if (this.isEventContext && !this.isExcluded(action.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)action);
            this.generateEventContextInterface((CdsDefinition)action, null);
        }
    }

    public void visit(CdsFunction function) {
        if (this.isEventContext && !this.isExcluded(function.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)function);
            this.generateEventContextInterface((CdsDefinition)function, null);
        }
    }

    public void visit(CdsStructuredType struct) {
        if (!struct.getName().isEmpty()) {
            NamesUtils.checkForJavaKeyword(struct.getQualifiedName());
            if (!this.isExcluded(struct.getQualifiedName())) {
                this.generateConsumptionInterface((CdsDefinition)struct);
                if (this.isTargetAspect(struct)) {
                    if (struct.elements().anyMatch(e -> e.getType().isStructured())) {
                        this.model.entities().flatMap(CdsStructuredType::associations).filter(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTargetAspect().map(ta -> ta.getName().equals(struct.getName())).orElse(false)).forEach(this::addTechnicalEntity);
                    }
                    this.generateBuilderInterface((CdsDefinition)struct);
                }
            }
        }
    }

    private CdsElement addTechnicalEntity(CdsElement element) {
        this.technicalEntities.add(((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget().getQualifiedName());
        this.entitiesWithAspectContainingStruct.add(element.getDeclaringType().getQualifiedName());
        return element;
    }

    private void collectWrapperInterfaces(CdsDefinition def) {
        String packageName = this.namesUtils.packageName(def);
        this.wrapperMap.put(packageName, def);
    }

    private void generateWrapperInterface(CdsDefinition def) {
        String qualifiedName = def.getQualifiedName();
        String name = def.getName();
        String packageName = this.namesUtils.packageName(def);
        String qualifiedWrapperName = NamesUtils.qualifiedWrapperBuilderName(def, this.config.getClassNameSuffix(), true);
        while (this.builderInterfaces.contains(qualifiedWrapperName.toLowerCase(Locale.US))) {
            qualifiedWrapperName = NamesUtils.getResolvedWrapperName(qualifiedWrapperName, this.config.getClassNameSuffix());
        }
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)NamesUtils.unqualifiedName(qualifiedWrapperName)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (WrapperInterfaceCreator.create(builder, this.model, this.config, this.entitiesWithAspectContainingStruct).generateInterface(NamesUtils.qualifiedContextname(qualifiedName, name))) {
            this.writeType(packageName, builder.build());
        }
    }

    private void generateConsumptionInterface(CdsDefinition def) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.className(def.getName()));
        this.addJavadoc(builder, def, () -> !(def instanceof CdsEventBuilder.EventProxy) && this.readDocs);
        String qualifiedTypeName = this.namesUtils.qualifiedJavaClassName(def);
        def.accept(CreateConsumptionInterfaceVisitor.create(builder, this.config, qualifiedTypeName));
        Optional parentAnnotation = def.findAnnotation("@cds.java.extends".substring(1));
        parentAnnotation.ifPresent(annotation -> {
            ArrayList baseEntities = (ArrayList)annotation.getValue();
            for (String baseEntityName : baseEntities) {
                CdsStructuredType baseEntity = this.model.getStructuredType(baseEntityName);
                String packageNameForBase = NamesUtils.packageName(this.config.getBasePackage(), baseEntity.getQualifiedName());
                builder.addSuperinterface((TypeName)ClassName.get((String)packageNameForBase, (String)baseEntity.getName(), (String[])new String[0]));
            }
        });
        TypeSpec typeSpec = builder.build();
        String packageName = this.namesUtils.packageName(def);
        this.writeType(packageName, typeSpec);
    }

    private void generateEventContextInterface(CdsDefinition def, CdsDefinition boundEntity) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.className(def.getName() + CONTEXT_SUFFIX));
        this.addJavadoc(builder, def, () -> this.readDocs);
        String boundEntityName = boundEntity == null ? null : boundEntity.getQualifiedName();
        def.accept(CreateEventContextInterfaceVisitor.create(builder, this.config, boundEntityName, def.getQualifiedName(), this.namesUtils));
        TypeSpec typeSpec = builder.build();
        String packageName = boundEntity != null ? this.namesUtils.packageName(boundEntity) : this.namesUtils.packageName(def);
        this.writeType(packageName, typeSpec);
    }

    private void generateBuilderInterface(CdsDefinition def) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.builderClassName(def));
        this.addJavadoc(builder, def, () -> this.readDocs);
        def.accept(CreateBuilderInterfaceVisitor.create(builder, this.config, this.namesUtils, this.entitiesWithAspectContainingStruct.contains(def.getQualifiedName())));
        this.builderInterfaces.add(NamesUtils.qualifiedWrapperBuilderName(def, this.config.getClassNameSuffix(), false).toLowerCase(Locale.US));
        TypeSpec typeSpec = builder.build();
        String packageName = this.namesUtils.packageName(def);
        this.writeType(packageName, typeSpec);
    }

    private void addJavadoc(TypeSpec.Builder builder, CdsDefinition def, Supplier<Boolean> doRead) {
        if (doRead.get().booleanValue()) {
            SpecWriterUtil.getJavaDoc((CdsAnnotatable)def).ifPresent(x$0 -> builder.addJavadoc(x$0, new Object[0]));
        }
    }

    private static TypeSpec.Builder createInterfaceSpecBuilder(ClassName type) {
        return TypeSpec.interfaceBuilder((ClassName)type).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private boolean isExcluded(String qualifiedName) {
        List<String> excludes = this.config.getExcludes();
        boolean excluded = false;
        int i = qualifiedName.lastIndexOf(46);
        if (i > 0) {
            String namespace = qualifiedName.substring(0, i);
            excluded = excludes.stream().filter(e -> !e.contains("*")).anyMatch(e -> e.equals(namespace));
        }
        if (!excluded) {
            excluded = excludes.stream().filter(e -> e.contains("*")).anyMatch(qualifiedName::matches);
        }
        return excluded;
    }

    private boolean isTargetAspect(CdsStructuredType struct) {
        return this.model.entities().flatMap(CdsStructuredType::associations).map(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTargetAspect()).anyMatch(ta -> ta.isPresent() && ((CdsType)ta.get()).getName().equals(struct.getName()));
    }

    private void writeType(String packageName, TypeSpec typeSpec) {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        final JavaFileObject fileObject = javaFile.toJavaFileObject();
        GeneratedFile jpaFile = new GeneratedFile(){

            @Override
            public URI getUri() {
                return fileObject.toUri();
            }

            @Override
            public InputStream getContent() throws IOException {
                return fileObject.openInputStream();
            }
        };
        try {
            this.consumer.accept(jpaFile);
        }
        catch (IOException e) {
            String message = String.format("Exception while writing to file %s.", jpaFile.getUri());
            throw new EntityWriterException(message, e);
        }
    }
}

