/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.generator.util;

import static com.sap.cds.generator.util.NamesUtils.qualifiedJavaClassName;

import java.util.Collection;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;

public class PoetTypeName {

	private PoetTypeName() {
	}

	public static TypeName getTypeFromCdsName(String basePackage, String qualifiedName, String name) {
		return getTypeName(qualifiedJavaClassName(basePackage, qualifiedName, name));
	}

	public static TypeName getTypeName(String javaType) {
		switch (javaType) {
		case "boolean":
			return TypeName.BOOLEAN;
		case "byte":
			return TypeName.BYTE;
		case "byte[]":
			return TypeName.get(byte[].class);
		case "short":
			return TypeName.SHORT;
		case "int":
			return TypeName.INT;
		case "long":
			return TypeName.LONG;
		case "char":
			return TypeName.CHAR;
		case "float":
			return TypeName.FLOAT;
		case "double":
			return TypeName.DOUBLE;
		default:
			try {
				int i = javaType.lastIndexOf('.');
				if (i > 0) {
					String packageName = javaType.substring(0, i);
					String className = javaType.substring(i + 1);
					return ClassName.get(packageName, className);
				} else {
					if (null != ClassName.get("", javaType)) {
						return ClassName.get("", javaType);
					}
					return ClassName.bestGuess(javaType);
				}
			} catch (IllegalArgumentException e) {
				String message = String.format("Failed to resolve type: %s.", javaType);
				throw new EntityWriterException(message, e);
			}
		}
	}

	public static TypeName getArrayTypeName(TypeName javaType) {
		ClassName set = ClassName.get(Collection.class);
		TypeName setWithParameter = ParameterizedTypeName.get(set, javaType);
		return setWithParameter;
	}
}
