/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.PatternMatcher;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesUtils {
    private static final String UP = "up_";
    private static final String DOT = ".";
    private static final Logger logger = LoggerFactory.getLogger(NamesUtils.class);
    private final List<String> excludes;
    private final List<String> includes;
    private final String basePackage;

    public NamesUtils(Configuration config) {
        this.basePackage = config.getBasePackage();
        this.excludes = config.getExcludes();
        this.includes = config.getIncludes();
    }

    public static String packageName(String basePackage, String qualifiedName) {
        String packageName = NamesUtils.namespace(qualifiedName);
        return NamesUtils.getPackageName(basePackage, packageName);
    }

    private static String getPackageName(String basePackage, String packageName) {
        if (!Strings.isNullOrEmpty((String)basePackage)) {
            packageName = Joiner.on((char)'.').skipNulls().join((Object)basePackage, (Object)packageName, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)packageName)) {
            packageName = "model";
        }
        return packageName.toLowerCase(Locale.US);
    }

    public static String namespace(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return null;
    }

    public static String qualifiedWrapperBuilderName(CdsDefinition def, String classNameSuffix, boolean isWrapper) {
        String name = (isWrapper ? CaseFormatHelper.toUpperCamel(NamesUtils.unqualifiedContextName(def.getQualifiedName(), def.getName())) : CaseFormatHelper.toUpperCamel(def.getName())) + classNameSuffix;
        if (def.getQualifiedName().equals(def.getName())) {
            return name;
        }
        return NamesUtils.qualifiedContextname(def.getQualifiedName(), def.getName()) + DOT + name;
    }

    public static String qualifiedContextname(String qualifiedName, String name) {
        if (name.contains(DOT)) {
            return NamesUtils.getQualifiedContextNameForDot(qualifiedName, name);
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return null;
    }

    public static String unqualifiedContextName(String qualifiedName, String name) {
        if (name.contains(DOT)) {
            String substring = NamesUtils.getQualifiedContextNameForDot(qualifiedName, name);
            if (substring.contains(DOT)) {
                String[] bits = substring.split("\\.");
                return bits[bits.length - 1];
            }
            return substring;
        }
        if (qualifiedName.contains(DOT)) {
            String[] bits = qualifiedName.split("\\.");
            return bits[bits.length - 2];
        }
        return "CdsModel";
    }

    public static String getQualifiedContextNameForDot(String qualifiedName, String name) {
        String qualifiedContextName = qualifiedName.substring(0, qualifiedName.lastIndexOf(name) - 1);
        if (Strings.isNullOrEmpty((String)qualifiedContextName)) {
            return "CdsModel";
        }
        return qualifiedContextName;
    }

    public static String unqualifiedName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        return qualifiedName.substring(lastDot + 1);
    }

    public static String qualifiedJavaClass(String basePackage, String entityName) {
        String packageName = NamesUtils.packageName(basePackage, entityName);
        String name = NamesUtils.unqualifiedName(entityName);
        return packageName + DOT + CaseFormatHelper.toUpperCamel(name);
    }

    public static String qualifiedJavaClassName(String basePackage, String qualifiedName, String name) {
        String namespace = NamesUtils.namespace(qualifiedName, name);
        String packageName = NamesUtils.getPackageName(basePackage, namespace);
        return packageName + DOT + CaseFormatHelper.toUpperCamel(name);
    }

    public static void checkForJavaKeyword(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            String[] split;
            for (String word : split = qualifiedName.split("\\.")) {
                if (!SourceVersion.isKeyword(word)) continue;
                logger.warn("The Entity " + qualifiedName + " contains a reserved Java keyword in its fully qualified name.");
            }
        }
    }

    public static String namespace(String qualifiedName, String name) {
        if (qualifiedName.equals(name)) {
            return null;
        }
        return qualifiedName.substring(0, qualifiedName.lastIndexOf(name) - 1);
    }

    public static boolean isValidTechnicalEntity(CdsModel model, String qualifiedName, Set<String> entitiesWithAspectContainingStruct) {
        Optional findEntity = model.findEntity(qualifiedName);
        boolean isTechnicalEntity = false;
        if (findEntity.isPresent()) {
            isTechnicalEntity = ((CdsEntity)findEntity.get()).elements().anyMatch(e -> e.getName().startsWith(UP));
        }
        return !isTechnicalEntity || entitiesWithAspectContainingStruct.contains(qualifiedName);
    }

    public static String innerInterfaceQualifiedName(CdsElement element, String basePackage) {
        String qualifiedElementName = element.getQualifiedName();
        int namespaceBeginIndex = qualifiedElementName.lastIndexOf(element.getDeclaringType().getName() + ":");
        String namespace = namespaceBeginIndex == 0 ? null : qualifiedElementName.substring(0, namespaceBeginIndex - 1).toLowerCase();
        String entityName = CaseFormatHelper.toUpperCamel(element.getDeclaringType().getName());
        if (!Strings.isNullOrEmpty((String)basePackage)) {
            return Joiner.on((char)'.').skipNulls().join((Object)basePackage, (Object)namespace, new Object[]{entityName, CaseFormatHelper.toUpperCamel(element.getName())});
        }
        return Joiner.on((char)'.').skipNulls().join((Object)namespace, (Object)(entityName.length() == 0 ? null : entityName), new Object[]{CaseFormatHelper.toUpperCamel(element.getName())});
    }

    public static String getResolvedWrapperName(String qualifiedBuilderName, String classNameSuffix) {
        return qualifiedBuilderName.substring(0, qualifiedBuilderName.length() - 1) + "Model" + classNameSuffix;
    }

    public String packageName(CdsDefinition def) {
        String packageName = NamesUtils.namespace(def.getQualifiedName(), def.getName());
        return NamesUtils.getPackageName(this.basePackage, packageName);
    }

    public String qualifiedJavaClassName(CdsDefinition def) {
        String packageName = this.packageName(def);
        return packageName + DOT + CaseFormatHelper.toUpperCamel(def.getName());
    }

    public boolean isExcluded(String qualifiedName) {
        boolean included = this.includes.isEmpty() ? true : this.matchesAny(qualifiedName, this.includes);
        return !(included &= !this.matchesAny(qualifiedName, this.excludes));
    }

    private boolean matchesAny(String qualifiedName, List<String> patternList) {
        return patternList.stream().map(p -> PatternMatcher.create(p)).anyMatch(pm -> pm.matches(qualifiedName));
    }
}

