/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.CdsPath;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class SpecWriterUtil {
    public static boolean addCdsNameAnnotation(MethodSpec.Builder builder, CdsElement attribute, String javaName) {
        boolean addCdsNameAnnotation;
        String attributeName = (String)attribute.getAnnotationValue(CdsAnnotatableImpl.removeAt((String)"@cds.java.name"), (Object)attribute.getName());
        boolean bl = addCdsNameAnnotation = !attribute.getName().equals(SpecWriterUtil.propertyName(javaName));
        if (addCdsNameAnnotation) {
            builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(CaseFormatHelper.toUpperUnderscore(attributeName), "$L"));
        }
        return addCdsNameAnnotation;
    }

    public static boolean addCdsPathAnnotation(MethodSpec.Builder builder, String cdsPath, String javaName) {
        boolean addCdsPathAnnotation;
        boolean bl = addCdsPathAnnotation = !cdsPath.equals(SpecWriterUtil.propertyName(javaName));
        if (addCdsPathAnnotation) {
            builder.addAnnotation(SpecWriterUtil.cdsPathAnnotation(CaseFormatHelper.toUpperUnderscore(cdsPath), "$L"));
        }
        return addCdsPathAnnotation;
    }

    public static AnnotationSpec cdsNameAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder(CdsName.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    public static AnnotationSpec cdsPathAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder(CdsPath.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    public static void addStaticField(TypeSpec.Builder builder, CdsElement element) {
        Optional<String> elementName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)element, element.getName());
        elementName.map(CaseFormatHelper::toUpperUnderscore).ifPresent(name -> {
            FieldSpec staticField = FieldSpec.builder(String.class, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{element.getName()}).build();
            builder.addField(staticField);
        });
    }

    public static Optional<String> getJavaDoc(CdsAnnotatable def) {
        return ((CdsAnnotatableImpl)def).getDoc();
    }

    public static void setJavaDoc(CdsAnnotatable attribute, MethodSpec.Builder methodBuilder) {
        SpecWriterUtil.getJavaDoc(attribute).ifPresent(a -> methodBuilder.addJavadoc(a.replace("$", "$$"), new Object[0]));
    }

    public static void addFkStaticField(TypeSpec.Builder builder, CdsElement attribute) {
        List<String> keys = SpecWriterUtil.resolveKeys(attribute).map(r -> r.segments().stream().map(seg -> seg.id()).collect(Collectors.joining("."))).collect(Collectors.toList());
        if (keys.size() > 0) {
            keys.forEach(fk -> {
                FieldSpec field = FieldSpec.builder(String.class, (String)CaseFormatHelper.toUpperUnderscore(fk.replaceAll("\\.", "_")), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{fk}).build();
                builder.addField(field);
            });
        }
    }

    private static Stream<CqnReference> resolveKeys(CdsElement assoc) {
        return SpecWriterUtil.resolveKeys((CqnReference)CQL.get((String)assoc.getName()), (CdsAssociationType)assoc.getType());
    }

    private static Stream<CqnReference> resolveKeys(CqnReference path, CdsAssociationType assoc) {
        return assoc.keys().flatMap(k -> {
            ElementRef ref = CQL.to((List)path.segments()).get(k.getName());
            if (k.getType().isAssociation()) {
                return SpecWriterUtil.resolveKeys((CqnReference)ref, (CdsAssociationType)k.getType());
            }
            return Stream.of(ref);
        });
    }

    private static String propertyName(String javaName) {
        if (javaName.startsWith("set") || javaName.startsWith("get")) {
            javaName = CaseFormatHelper.lowercaseFirst(javaName.substring(3));
        }
        return javaName;
    }
}

