/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuilderInterfaceVisitor
implements CdsVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CreateBuilderInterfaceVisitor.class);
    private static final String FILTER = "filter";
    private final TypeSpec.Builder entityClass;
    private final Configuration cfg;
    private final NamesUtils namesUtils;
    private String entityName;

    private CreateBuilderInterfaceVisitor(TypeSpec.Builder builder, Configuration cfg, NamesUtils namesUtils) {
        this.entityClass = builder;
        this.namesUtils = namesUtils;
        this.cfg = cfg;
    }

    public static CdsVisitor create(TypeSpec.Builder builder, Configuration cfg, NamesUtils namesUtils) {
        return new CreateBuilderInterfaceVisitor(builder, cfg, namesUtils);
    }

    public void visit(CdsEntity entity) {
        this.generateInterface((CdsDefinition)entity);
    }

    public void visit(CdsStructuredType struct) {
        this.generateInterface((CdsDefinition)struct);
    }

    public void visit(CdsElement attribute) {
        if (attribute.getType().isStructured() && ((CdsStructuredType)attribute.getType().as(CdsStructuredType.class)).isAnonymous()) {
            this.addAnonymousStructAttribute(attribute);
        } else if (!attribute.getType().isAssociation()) {
            this.addAttribute(attribute);
        } else {
            this.addAssociationAttribute(attribute);
        }
    }

    private void generateInterface(CdsDefinition def) {
        ClassName type = TypeUtils.builderClassName(def);
        this.entityClass.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.STRUCTUREDTYPE, (TypeName[])new TypeName[]{type}));
        this.entityClass.addAnnotation(AnnotationSpec.builder(CdsName.class).addMember("value", "$S", new Object[]{def.getQualifiedName()}).build());
        this.addStaticQualifiedAttribute(def);
        this.entityName = def.getName();
    }

    private void addAnonymousStructAttribute(CdsElement attribute) {
        String unqualifiedClassName = CaseFormatHelper.toUpperCamel(attribute.getName()) + this.cfg.getClassNameSuffix();
        this.entityClass.addMethod(MethodSpec.methodBuilder((String)attribute.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(PoetTypeName.getTypeName(unqualifiedClassName)).build());
        Stream elements = ((CdsStructuredType)attribute.getType().as(CdsStructuredType.class)).elements();
        this.addInnerInterface(attribute, unqualifiedClassName, elements);
    }

    private void addInnerInterface(CdsElement attribute, String unqualifiedClassName, Stream<CdsElement> elements) {
        TypeSpec.Builder innerIntefaceBuilder = TypeSpec.interfaceBuilder((String)unqualifiedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        innerIntefaceBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.STRUCTUREDTYPE, (TypeName[])new TypeName[]{PoetTypeName.getTypeName(unqualifiedClassName)}));
        elements.forEach(e -> e.accept(CreateBuilderInterfaceVisitor.create(innerIntefaceBuilder, this.cfg, this.namesUtils)));
        this.entityClass.addType(innerIntefaceBuilder.build());
    }

    private void addStaticQualifiedAttribute(CdsDefinition def) {
        String qualifiedName = def.getQualifiedName();
        FieldSpec staticField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{qualifiedName}).build();
        this.entityClass.addField(staticField);
    }

    private void addAssociationAttribute(CdsElement attribute) {
        if (TypeUtils.isAnonymousAspect(attribute)) {
            this.addInnerInterface(attribute, CaseFormatHelper.toUpperCamel(attribute.getName()) + this.cfg.getClassNameSuffix(), TypeUtils.getAnonymousElements(attribute));
        }
        this.addMainFunction(attribute);
        this.addFilterFunction(attribute);
    }

    private void addAttribute(CdsElement attribute) {
        Optional<String> attrName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)attribute, attribute.getName());
        attrName.ifPresent(name -> {
            ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)Types.REFERENCE, (TypeName[])new TypeName[]{TypeUtils.getReturnType(attribute, this.cfg)});
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType);
            if (SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute, name)) {
                SpecWriterUtil.addStaticField(this.entityClass, attribute);
            }
            this.entityClass.addMethod(methodBuilder.build());
        });
    }

    private void addMainFunction(CdsElement attribute) {
        String targetEntityClassName = this.getTargetName(attribute);
        TypeName returnType = PoetTypeName.getTypeName(targetEntityClassName);
        this.entityClass.addMethod(MethodSpec.methodBuilder((String)attribute.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(returnType).build());
    }

    private void addFilterFunction(CdsElement attribute) {
        if (!attribute.getName().equalsIgnoreCase(FILTER)) {
            String targetEntityClassName = this.getTargetName(attribute);
            TypeName returnType = PoetTypeName.getTypeName(targetEntityClassName);
            this.entityClass.addMethod(MethodSpec.methodBuilder((String)attribute.getName()).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{returnType, Types.PREDICATE}), FILTER, new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(returnType).build());
        } else {
            logger.warn("There is a name clash between the element 'filter' of entity '" + this.entityName + "' and a method in the super interface StructuredType. A filter function accepting predicates will not be generated.");
        }
    }

    public String getTargetName(CdsElement element) {
        CdsAssociationType association = (CdsAssociationType)element.getType();
        CdsType target = association.getTargetAspect().orElseGet(() -> ((CdsAssociationType)association).getTarget());
        if (target.getQualifiedName().isEmpty()) {
            return CaseFormatHelper.toUpperCamel(element.getName()) + this.cfg.getClassNameSuffix();
        }
        return this.interfaceName((CdsDefinition)target);
    }

    public String interfaceName(CdsDefinition def) {
        return PoetTypeName.getTypeName(this.namesUtils.qualifiedJavaClassName(def)) + this.cfg.getClassNameSuffix();
    }
}

