/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.google.common.collect.Streams;
import com.sap.cds.generator.Cds4jCodegen;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.EntityWriterException;
import com.sap.cds.generator.util.GeneratedAnnotationUtil;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.util.UnSupportedModelException;
import com.sap.cds.generator.writer.CreateBuilderInterfaceVisitor;
import com.sap.cds.generator.writer.CreateConsumptionInterfaceVisitor;
import com.sap.cds.generator.writer.CreateEventContextInterfaceVisitor;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.WrapperInterfaceCreator;
import com.sap.cds.impl.util.Pair;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

public class ModelWriter
implements CdsVisitor {
    private static final String CONTEXT_SUFFIX = "Context";
    private final GeneratedFile.Consumer consumer;
    private final Configuration config;
    private final CdsModel model;
    private final Map<String, CdsDefinition> wrapperMap;
    private final Set<String> builderInterfaces;
    private final boolean isEventContext;
    private final boolean readDocs;
    private final NamesUtils namesUtils;
    private final GeneratedAnnotationUtil generated;

    public ModelWriter(GeneratedFile.Consumer consumer, Configuration config, CdsModel model) {
        this.consumer = consumer;
        this.config = config;
        this.model = model;
        this.wrapperMap = new HashMap<String, CdsDefinition>();
        this.builderInterfaces = new HashSet<String>();
        this.isEventContext = Boolean.parseBoolean(config.getEventContext());
        this.namesUtils = new NamesUtils(config);
        this.generated = new GeneratedAnnotationUtil(config);
        this.readDocs = config.getDocs();
    }

    public void visit(CdsModel model) {
        this.wrapperMap.values().forEach(this::generateWrapperInterface);
    }

    public void visit(CdsEntity entity) {
        NamesUtils.checkForJavaKeyword(entity.getQualifiedName());
        if (!this.namesUtils.isExcluded(entity.getQualifiedName()) && NamesUtils.isValidTechnicalEntity(this.model, entity.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)entity);
            this.generateBuilderInterface((CdsDefinition)entity);
            this.generateConsumptionInterface((CdsDefinition)entity);
            if (this.isEventContext) {
                Streams.concat((Stream[])new Stream[]{entity.actions(), entity.functions()}).forEach(a -> this.generateEventContextInterface((CdsDefinition)a, (CdsDefinition)entity));
            }
        }
    }

    public void visit(CdsEvent event) {
        NamesUtils.checkForJavaKeyword(event.getQualifiedName());
        if (!this.namesUtils.isExcluded(event.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)event);
            this.generateConsumptionInterface((CdsDefinition)event);
            if (this.isEventContext) {
                this.generateEventContextInterface((CdsDefinition)event, null);
            }
        }
    }

    public void visit(CdsAction action) {
        if (this.isEventContext && !this.namesUtils.isExcluded(action.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)action);
            this.generateEventContextInterface((CdsDefinition)action, null);
        }
    }

    public void visit(CdsFunction function) {
        if (this.isEventContext && !this.namesUtils.isExcluded(function.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)function);
            this.generateEventContextInterface((CdsDefinition)function, null);
        }
    }

    public void visit(CdsStructuredType struct) {
        if (!struct.getName().isEmpty()) {
            NamesUtils.checkForJavaKeyword(struct.getQualifiedName());
            if (!this.namesUtils.isExcluded(struct.getQualifiedName())) {
                this.generateConsumptionInterface((CdsDefinition)struct);
                if (this.isTargetAspect(struct)) {
                    TypeUtils.logWarningForManyToManyWithStructElement(this.model, struct);
                    this.generateBuilderInterface((CdsDefinition)struct);
                }
            }
        }
    }

    private void collectWrapperInterfaces(CdsDefinition def) {
        String packageName = this.namesUtils.packageName(def);
        this.wrapperMap.put(packageName, def);
    }

    private void generateWrapperInterface(CdsDefinition def) {
        String qualifiedName = def.getQualifiedName();
        String name = def.getName();
        String packageName = this.namesUtils.packageName(def);
        String qualifiedWrapperName = NamesUtils.qualifiedWrapperBuilderName(def, this.config.getClassNameSuffix(), true);
        while (this.builderInterfaces.contains(qualifiedWrapperName.toLowerCase(Locale.US))) {
            qualifiedWrapperName = NamesUtils.getResolvedWrapperName(qualifiedWrapperName, this.config.getClassNameSuffix());
        }
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)NamesUtils.unqualifiedName(qualifiedWrapperName)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.generated.addTo(builder);
        if (WrapperInterfaceCreator.create(builder, this.model, this.config).generateInterface(NamesUtils.qualifiedContextname(qualifiedName, name))) {
            this.writeType(packageName, builder.build());
        }
    }

    private void generateConsumptionInterface(CdsDefinition def) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.className(def.getName()));
        this.addJavadoc(builder, def, () -> !(def instanceof CdsEventBuilder.EventProxy) && this.readDocs);
        String qualifiedTypeName = this.namesUtils.qualifiedJavaClassName(def);
        def.accept(CreateConsumptionInterfaceVisitor.create(builder, this.config, qualifiedTypeName));
        ((List)def.getAnnotationValue("@cds.java.extends".substring(1), Collections.emptyList())).stream().map(arg_0 -> ((CdsModel)this.model).getStructuredType(arg_0)).map(this::throwErrorOnExtendEntity).map(this.namesUtils::qualifiedJavaClassName).map(ClassName::bestGuess).forEach(arg_0 -> ((TypeSpec.Builder)builder).addSuperinterface(arg_0));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        String packageName = this.namesUtils.packageName(def);
        this.writeType(packageName, typeSpec);
    }

    private boolean isFuncOrAction(CdsDefinition def) {
        return def.getKind().equals((Object)CdsKind.ACTION) || def.getKind().equals((Object)CdsKind.FUNCTION);
    }

    private void generateEventContextInterface(CdsDefinition def, CdsDefinition boundEntity) {
        if (Cds4jCodegen.isIgnored(def)) {
            return;
        }
        String defName = def.getName();
        String defQualifiedName = def.getQualifiedName();
        if (this.isFuncOrAction(def)) {
            Pair<String, String> qualifiedName = NamesUtils.getEffectiveNames(def);
            defName = (String)qualifiedName.left;
            defQualifiedName = (String)qualifiedName.right;
        }
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.className(defName + CONTEXT_SUFFIX));
        this.addJavadoc(builder, def, () -> this.readDocs);
        String boundEntityName = boundEntity == null ? null : boundEntity.getQualifiedName();
        def.accept(CreateEventContextInterfaceVisitor.create(builder, this.config, boundEntityName, defQualifiedName, this.namesUtils));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        String packageName = boundEntity != null ? this.namesUtils.packageName(boundEntity) : this.namesUtils.packageName(def);
        this.writeType(packageName, typeSpec);
    }

    private CdsStructuredType throwErrorOnExtendEntity(CdsStructuredType struct) {
        if (struct.getKind().equals((Object)CdsKind.ENTITY) && !((CdsEntity)struct.as(CdsEntity.class)).isAbstract()) {
            throw new UnSupportedModelException("The '@cds.java.extends' annotation does not support extending an entity.");
        }
        return struct;
    }

    private void generateBuilderInterface(CdsDefinition def) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.builderClassName(def));
        this.addJavadoc(builder, def, () -> this.readDocs);
        def.accept(CreateBuilderInterfaceVisitor.create(builder, this.config, this.namesUtils));
        this.builderInterfaces.add(NamesUtils.qualifiedWrapperBuilderName(def, this.config.getClassNameSuffix(), false).toLowerCase(Locale.US));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        String packageName = this.namesUtils.packageName(def);
        this.writeType(packageName, typeSpec);
    }

    private void addJavadoc(TypeSpec.Builder builder, CdsDefinition def, Supplier<Boolean> doRead) {
        if (doRead.get().booleanValue()) {
            SpecWriterUtil.getJavaDoc((CdsAnnotatable)def).ifPresent(a -> builder.addJavadoc(a.replace("$", "$$"), new Object[0]));
        }
    }

    private static TypeSpec.Builder createInterfaceSpecBuilder(ClassName type) {
        return TypeSpec.interfaceBuilder((ClassName)type).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private boolean isTargetAspect(CdsStructuredType struct) {
        return this.model.entities().flatMap(CdsStructuredType::associations).map(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTargetAspect()).anyMatch(ta -> ta.isPresent() && ((CdsType)ta.get()).getName().equals(struct.getName()));
    }

    private void writeType(String packageName, TypeSpec typeSpec) {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        final JavaFileObject fileObject = javaFile.toJavaFileObject();
        GeneratedFile jpaFile = new GeneratedFile(){

            @Override
            public URI getUri() {
                return fileObject.toUri();
            }

            @Override
            public InputStream getContent() throws IOException {
                return fileObject.openInputStream();
            }
        };
        try {
            this.consumer.accept(jpaFile);
        }
        catch (IOException e) {
            String message = String.format("Exception while writing to file %s.", jpaFile.getUri());
            throw new EntityWriterException(message, e);
        }
    }
}

